/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.BackgroundTaskDialog;
import de.willuhn.jameica.gui.internal.dialogs.PluginSourceDialog;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.plugin.ZippedPlugin;
import de.willuhn.jameica.services.DeployService;
import de.willuhn.jameica.services.PluginSourceService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.File;
import java.util.List;
import org.eclipse.swt.widgets.FileDialog;

public class PluginInstall
implements Action {
    private static final Settings settings = new Settings(PluginInstall.class);

    @Override
    public void handleAction(Object context) throws ApplicationException {
        I18N i18n = Application.getI18n();
        try {
            FileDialog d = new FileDialog(GUI.getShell(), 4096);
            d.setText(i18n.tr("Bitte w\u00e4hlen Sie die ZIP-Datei mit dem zu installierenden Plugin aus."));
            d.setFilterExtensions(new String[]{"*.zip"});
            d.setFilterPath(settings.getString("lastdir", System.getProperty("user.home")));
            String file = d.open();
            if (file == null) {
                return;
            }
            File f = new File(file);
            if (!f.canRead() || !f.isFile()) {
                throw new ApplicationException(i18n.tr("Die Datei {0} ist nicht lesbar", f.getName()));
            }
            settings.setAttribute("lastdir", f.getParent());
            final ZippedPlugin plugin = new ZippedPlugin(f);
            Manifest mf = plugin.getManifest();
            Manifest installed = Application.getPluginLoader().getManifestByName(mf.getName());
            if (installed != null) {
                throw new ApplicationException(i18n.tr("Das Plugin ist bereits installiert."));
            }
            mf.canDeploy();
            final PluginSource source = this.getPluginSource(mf);
            BackgroundTask task = new BackgroundTask(){

                @Override
                public void run(ProgressMonitor monitor) throws ApplicationException {
                    DeployService service = (DeployService)Application.getBootLoader().getBootable(DeployService.class);
                    service.deploy(plugin, source, monitor);
                }

                @Override
                public boolean isInterrupted() {
                    return false;
                }

                @Override
                public void interrupt() {
                }
            };
            BackgroundTaskDialog bd = new BackgroundTaskDialog(1, task);
            bd.setTitle(i18n.tr("Installiere..."));
            bd.setSideImage(SWTUtil.getImage("emblem-package.png"));
            bd.setPanelText(i18n.tr("Installiere Plugin"));
            bd.open();
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
        }
        catch (Exception e) {
            Logger.error((String)"unable to install plugin", (Throwable)e);
            throw new ApplicationException(i18n.tr("Installation fehlgeschlagen: {0}", e.getMessage()));
        }
    }

    private PluginSource getPluginSource(Manifest mf) throws Exception {
        PluginSourceService service = (PluginSourceService)Application.getBootLoader().getBootable(PluginSourceService.class);
        List<PluginSource> sources = service.getWritableSources();
        if (sources.size() == 1) {
            return sources.get(0);
        }
        if (sources.size() > 1) {
            PluginSourceDialog psd = new PluginSourceDialog(1, mf);
            return (PluginSource)psd.open();
        }
        return null;
    }
}

